package gov.va.med.mhv.common.api.enumeration;


import java.util.Arrays;
import java.util.List;

public enum ErrorEnum {
	UNKNOWN_99 (99,"Unknown application error occurred"), 
	APPLICATION_AUTHENTICATION_FAILED_101 (101,"Application authentication failed"),
	APPLICATION_AUTHORIZATION_FAILED_102 (102,"Application authorization failed"),
	INVALID_USER_CREDENTIALS_103 (103,"Invalid User Credentials"),
	MISSING_USER_CREDENTIALS_104 (104,"Missing User Credentials"),
	USER_NOT_FOUND_105 (105, "User was not found"), 
	INELIGIBLE_USER_REASON_BLOCKED_106 (106, "User is not eligible because they are blocked"), 
	UNABLE_TO_CREATE_TOKEN_107 (107, "System unable to create token"),
	MISSING_SESSION_TOKEN_108 (108, "Missing session token"), 
	INVALID_SESSION_TOKEN_109 (109,"Invalid session token"), 
	EXPIRED_SESSION_TOKEN_110 (110, "Expired session token"), 
	INVALID_USER_PERMISSIONS_111 (111,"Invalid user permissions (invalid user type for resource requested)"), 
	NOT_OWNER_OF_ENTITY_112 (112, "User is not owner of entity requested"),
	USER_ACCOUNT_DEACTIVE_113 (113, "User Account is being Deactivated"),
	USER_MHV_TC_STALE__114 (114, "User has not accepted the latest Terms and Conditions"),
	NOT_FOUND_115 (115, "Entity not found"),
	DATA_INTEGRITY_ERROR_117 (117,"A data integrity issue was encountered"), 
	MISSING_APPLICATION_TOKEN_132 (132, "Missing application token"),
	
	DOC_TYPE_NOT_SUPPORTED_133 (133, "The Document Type is not supported"),
	
	// RxService
	RX_USER_ACCESS_DENIED_134 (134, "The User is denied in RxRefill"),
	RX_AGREEMENT_NOT_ACCEPTED_135 (135, "The User has not accepted the Rx Agreement. Please login to MHV to accept it"),
	RX_USER_NOT_OWNER_136 (136, "The User is not the owner of the prescription"),
	NO_PRESCRIPTIONID_FOR_REFILL_137 (137, "No prescription id exists for refill"),
	PRESCRIPTIONID_NOT_FOUND_138 (138, "Prescription is not Found"),
	PRESCRIPTIONID_NOT_REFILLABLE_139 (139, "Prescription is not Refillable"),
	PRESCRIPTIONID__REFILL_ERROR_140 (140, "Prescription Refill was unsuccessful. Please try again later"),
	AUTHENTICATION_SERVICE_ERROR_901 (901, "Authentication Service Error"),
	AUTHENTICATION_SESSION_UNAVAILABLE_902 (902, "Authentication Session not Available"),

	// Audit Activity
	
	INVALID__PERFORMEDBY_141 (141, "PerformedBy is invalid"),
	
	//Alternative Registration Flow
	USER_REGISTRATION_FAILED (142, "Error Unknown"),
	USER_REGISTRATION_FAILED_MULTI_USER_EXISTS (143, "Multiplw User Exists"),
	USER_REGISTRATION_SUCCESS_NO_MATCH_MVI (144, "User Does not exist in MVI"),
	USER_REGISTRATION_SUCCESS_CORR_FAILED (145, "User Correlation Failed MVI"),
	USER_REGISTRATION_AUTHENTICATION_FAILED (146, "User Authentication Failed in MVI"),
	USER_REGISTRATION_INVALID_INPUT (147, "User input is invalid"),
	USER_REGISTRATION_EXIST_CORR (148, "User already in correlated state in MVI"),
	USER_REGISTRATION_EXIST_CORR_MHV (149, "User already in correlated state in MHV"),
	USER_REGISTRATION_MVI_ISSUE (150, "MVI Unknown Issue Occurred"),
	USER_REGISTRATION_MULTI_MHV_ACC (151, "Multiple MHV Account is Found"),
	USER_REGISTRATION_ICNSSN_MISMATCH (152, "ICN/SSN Mismatch issue"),
		
	//Alternate Account Premium Upgrade
	USER_ACCTUPGRADE_FAILED(153, "Account Upgrade Failed"),
	USER_MVI_ACCTUPGRADE_FAILED(154, "Mvi Account Upgrade Failed"),
	USER_MVI_ACCT_ALREADY_UPGRADED(155, "Account is already Upgraded"),
	
	// User Notification Update
	USER_NOTIFICATION_NOEMAILADDRESS(156, "Email Address doesnt exist in Account"),
	USER_NOTIFICATION_INVALIDEMAILADDRESS(157, "Email Address is Invalid"),
	
	USER_REGISTRATION_RESTRICT_SIP(158, "Sign-in Partner Blocked");
	
	
	private int id;
	private String errorMessage;
	private Class<?> clazz;
	
	private ErrorEnum() {
	}
	
	private ErrorEnum(int id, String errorMessage){
		this.id = id;
		this.errorMessage = errorMessage;
		this.clazz = null;
	}
	private ErrorEnum(int id, String errorMessage, Class<?> clazz){
		this.id = id;
		this.errorMessage = errorMessage;
		this.clazz = clazz;
	}
	public int getId() {
		return id;
	}
	public void setId(int id) {
		this.id = id;
	}
	public String getErrorMessage() {
		return errorMessage;
	}
	public void setErrorMessage(String errorMessage) {
		this.errorMessage = errorMessage;
	}
	public Class<?> getClazz() {
		return clazz;
	}
	public void setClazz(Class<?> clazz) {
		this.clazz = clazz;
	}
	
	public static ErrorEnum valueOf(int id) throws Exception {
		for(ErrorEnum f : ErrorEnum.values()){
			if(f.getId()==(id))
				return f;
		}
		/* none found; throw error */
		throw new Exception("No SourceEnum found matching " + id);
	}
	
	public static List<ErrorEnum> toList(){
		return Arrays.asList(ErrorEnum.values());
	}
}
